<?php

namespace Modules\Amazon\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Amazon\Entities\AmazonFbaInboundShipmentItem;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlanItem;

/**
 * @mixin AmazonNewFbaInboundPlanItem
 */
class AmazonFbaInboundPlanItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'labelOwner' => $this->labelOwner,
            'msku' => $this->msku,
            'quantity' => $this->quantity,
            'fnsku' => $this->fnsku,
            'asin' => $this->asin,
            'prepInstructions' => $this->prepInstructions,
        ];
    }
}
