<?php

namespace Modules\Amazon\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Response;
use Exception;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonManager;

class FbaInventoryValuationController extends Controller
{
    /**
     * @throws Exception
     */
    public function __invoke(AmazonIntegrationInstance $integrationInstance): Response
    {
        return $this->response->addData((new AmazonManager($integrationInstance))->fbaInventoryValuation());
    }
}
