<?php

namespace Modules\Amazon\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderController;
use App\Data\CreateSkuOrderFromSalesChannelData;
use App\Exceptions\ExportingEmptyDataException;
use App\Response;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetOrdersAdt;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonOrder;
use Modules\Amazon\Http\Resources\AmazonOrderResource;
use Modules\Amazon\Jobs\RefreshAmazonOrdersJob;
use Modules\Amazon\Repositories\AmazonOrderRepository;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Throwable;

class AmazonOrderController extends AbstractSalesChannelOrderController
{
    protected function getModel(): string
    {
        return AmazonOrder::class;
    }

    protected function getResource(): string
    {
        return AmazonOrderResource::class;
    }

    // Typehint $integrationInstance with the integration implementation
    public function indexForIntegration(Request $request, AmazonIntegrationInstance $integrationInstance)
    {
        return parent::abstractIndexForIntegration($request, $integrationInstance);
    }

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonOrder $order): Response
    {
        return parent::abstractShow($order);
    }

    /**
     * @throws Throwable
     */
    public function createSkuOrders(CreateSkuOrderFromSalesChannelData $data, AmazonIntegrationInstance $integrationInstance): Response
    {
        return parent::abstractCreateSkuOrders($data, $integrationInstance);
    }

    public function refresh(AmazonIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshAmazonOrdersJob($integrationInstance, app($this->getModel())->refreshAdt()));
    }

    /**
     * @throws ExportingEmptyDataException
     */
    protected function exportForIntegration(Request $request, AmazonIntegrationInstance $integrationInstance): BinaryFileResponse|Response|RedirectResponse
    {
        return $this->abstractExportForIntegration($request, $integrationInstance);
    }
}
