<?php

namespace Modules\Amazon\Http\Controllers;

use App\DataTable\DataTableResource;
use App\Response;
use Exception;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetInboundPlansAdt;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlan;
use Modules\Amazon\Enums\Entities\AmazonNewFbaInboundShipmentStatusEnum;
use Modules\Amazon\Enums\Entities\FbaInboundPlanStatusEnum;
use Modules\Amazon\Http\Controllers\Concerns\AmazonExportableControllerTrait;
use Modules\Amazon\Http\Resources\AmazonFbaInboundPlanResource;
use Modules\Amazon\Managers\AmazonNewInboundManager;
use Modules\Amazon\Repositories\AmazonNewFbaInboundPlanRepository;

class AmazonNewFbaInboundPlanController extends AbstractAmazonDataTableController
{
    use AmazonExportableControllerTrait;

    private AmazonNewFbaInboundPlanRepository $plans;

    public function __construct()
    {
        $this->plans = app(AmazonNewFbaInboundPlanRepository::class);
        parent::__construct();
    }

    protected function getResource(): DataTableResource|string
    {
        return AmazonFbaInboundPlanResource::class;
    }

    protected function getModel(): string
    {
        return AmazonNewFbaInboundPlan::class;
    }

    /**
     * @throws Exception
     */
    public function refresh(AmazonIntegrationInstance $integrationInstance): Response
    {
        (new AmazonNewInboundManager($integrationInstance))->refreshPlans(new AmazonGetInboundPlansAdt(
            status: FbaInboundPlanStatusEnum::SHIPPED
        ));
        // need to get both SHIPPED and ACTIVE because some that are ACTIVE have shipments
        (new AmazonNewInboundManager($integrationInstance))->refreshPlans(new AmazonGetInboundPlansAdt(
            status: FbaInboundPlanStatusEnum::ACTIVE
        ));

        return $this->response->setMessage('Inbound plans downloading...');
    }
}
