<?php

namespace Modules\Amazon\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Repositories\NominalCodeRepository;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Requests\MapAmazonFinancialEventTypeNominalCodeRequest;
use Modules\Amazon\Repositories\AmazonFinancialEventTypeNominalCodeMappingRepository;

class AmazonFinancialEventTypeNominalCodeMappingController extends Controller
{
    private AmazonFinancialEventTypeNominalCodeMappingRepository $nominalCodeMappings;

    private NominalCodeRepository $nominalCodes;

    public function __construct()
    {
        $this->nominalCodeMappings = app(AmazonFinancialEventTypeNominalCodeMappingRepository::class);
        $this->nominalCodes = app(NominalCodeRepository::class);

        parent::__construct();
    }

    public function index(AmazonIntegrationInstance $integrationInstance)
    {
        return $this->response->addData($this->nominalCodeMappings->getAllNominalCodeMappings($integrationInstance));
    }

    public function store(MapAmazonFinancialEventTypeNominalCodeRequest $request, AmazonIntegrationInstance $integrationInstance)
    {
        collect($request->validated()['mappings'])->each(function (array $mapping) use ($integrationInstance) {
            $this->nominalCodeMappings->mapNominalCode(
                $this->nominalCodeMappings->getAllNominalCodeMappingById($integrationInstance, $mapping['id']),
                $this->nominalCodes->getNominalCodeById($mapping['nominal_code_id'])
            );
        });

        return $this->response->setMessage('Nominal codes successfully mapped.');
    }
}
