<?php

namespace Modules\Amazon\Http\Controllers;

use App\DataTable\DataTableResource;
use App\Response;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedgerSummary;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Controllers\Concerns\AmazonExportableControllerTrait;
use Modules\Amazon\Http\Resources\AmazonFbaReportInventoryLedgerSummaryResource;
use Modules\Amazon\Managers\AmazonLedgerSummaryManager;
use Modules\Amazon\Repositories\AmazonReportRepository;
use Throwable;

class AmazonFbaReportInventoryLedgerSummaryController extends AbstractAmazonDataTableController
{
    use AmazonExportableControllerTrait;

    private AmazonReportRepository $amazonReportRepository;

    public function __construct()
    {
        $this->amazonReportRepository = app(AmazonReportRepository::class);
        parent::__construct();
    }

    protected function getModel(): string
    {
        return AmazonFbaReportInventoryLedgerSummary::class;
    }

    public static function getRequiredRelations(): array
    {
        return [
            'amazonFnskuProduct.product',
            'ledgers',
            'ledgerSummaryAdjustments.inventoryAdjustment',
        ];
    }

    protected function getResource(): DataTableResource|string
    {
        return AmazonFbaReportInventoryLedgerSummaryResource::class;
    }

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportInventoryLedgerSummary $ledger_summary): ?Response
    {
        $ledger_summary->load(static::getRequiredRelations());

        return $this->response->addData($this->getResource()::make($ledger_summary));
    }

    public function reconcileAll(AmazonIntegrationInstance $integrationInstance): Response
    {
        $ledgerSummaries = (new AmazonLedgerSummaryManager($integrationInstance))->reconcileAll();
        return $this->response->addData($this->getResource()::collection($ledgerSummaries));
    }

    /**
     * @throws Throwable
     */
    public function reconcile(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportInventoryLedgerSummary $ledgerSummary): Response
    {
        $ledgerSummary = (new AmazonLedgerSummaryManager($integrationInstance))->reconcile($ledgerSummary);
        return $this->response->addData($this->getResource()::make($ledgerSummary->load(static::getRequiredRelations())));
    }

    public function unreconcileAll(AmazonIntegrationInstance $integrationInstance): Response
    {
        $ledgerSummaries = (new AmazonLedgerSummaryManager($integrationInstance))->unreconcileAll();
        return $this->response->addData($this->getResource()::collection($ledgerSummaries));
    }

    /**
     * @throws Throwable
     */
    public function unreconcile(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportInventoryLedgerSummary $ledgerSummary): Response
    {
        $ledgerSummary = (new AmazonLedgerSummaryManager($integrationInstance))->unreconcile($ledgerSummary);
        return $this->response->addData($this->getResource()::make($ledgerSummary->load(static::getRequiredRelations())));
    }
}
