<?php

namespace Modules\Amazon\Http\Controllers;

use App\DataTable\DataTableResource;
use App\Response;
use Modules\Amazon\Entities\AmazonFbaReportCustomerReturn;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Controllers\Concerns\AmazonExportableControllerTrait;
use Modules\Amazon\Http\Resources\AmazonFbaReportCustomerReturnResource;
use Modules\Amazon\Repositories\AmazonReportRepository;

class AmazonFbaReportCustomerReturnController extends AbstractAmazonDataTableController
{
    use AmazonExportableControllerTrait;

    private AmazonReportRepository $amazonReportRepository;

    public function __construct()
    {
        $this->amazonReportRepository = app(AmazonReportRepository::class);
        parent::__construct();
    }

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportCustomerReturn $customerReturn): ?Response
    {
        return $this->response->addData(AmazonFbaReportCustomerReturnResource::make($customerReturn));
    }

    protected function getModel(): string
    {
        return AmazonFbaReportCustomerReturn::class;
    }

    protected function getResource(): DataTableResource|string
    {
        return AmazonFbaReportCustomerReturnResource::class;
    }
}
