<?php

namespace Modules\Amazon\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Response;
use Exception;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonReportManager;

class AmazonFbaLpnLookupController extends Controller
{
    /**
     * @throws Exception
     */
    public function __invoke(Request $request, AmazonIntegrationInstance $integrationInstance): Response
    {
        $request->validate([
            'lpn' => 'required|string',
        ]);

        $customerReturn = (new AmazonReportManager($integrationInstance))->getCustomerReturnFromLpn($request->input('lpn'));

        return $this->response->addData($customerReturn);
    }
}
