<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum FbaInventoryLedgerReportEventTypeEnum: string
{
    use InvokableCases,
        Values;

    case Adjustments = 'Adjustments';
    case CustomerReturns = 'CustomerReturns';
    case Receipts = 'Receipts';
    case Shipments = 'Shipments';
    case VendorReturns = 'VendorReturns';
    case WarehouseTransfers = 'WhseTransfers';

    public const NegativeQuantities = [
        'Shipments',
        'VendorReturns',
    ];

    public const Kept = [
        'Adjustments',
        'CustomerReturns',
        'Receipts',
        'Shipments',
        'VendorReturns',
    ];

    public const HasDetailReports = [
        'CustomerReturns',
        'Shipments',
        'VendorReturns',
    ];
}
