<?php

namespace Modules\Amazon\Enums\Entities;

use App\Models\WarehouseTransfer;
use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum FbaInboundShipmentStatusEnum: string
{
    use InvokableCases, Values;

    case WORKING = 'WORKING';
    case READY_TO_SHIP = 'READY_TO_SHIP';
    case SHIPPED = 'SHIPPED';
    case RECEIVING = 'RECEIVING';
    case CANCELLED = 'CANCELLED';
    case DELETED = 'DELETED';
    case CLOSED = 'CLOSED';
    case ERROR = 'ERROR';
    case IN_TRANSIT = 'IN_TRANSIT';
    case DELIVERED = 'DELIVERED';
    case CHECKED_IN = 'CHECKED_IN';

    // TODO: Once we upgrade to php 8.2, we can do something like self::WORKING->value
    public const STATUSES_ACTIVE = [
        'WORKING',
        'READY_TO_SHIP',
        'SHIPPED',
        'RECEIVING',
        'CLOSED',
        'IN_TRANSIT',
        'DELIVERED',
        'CHECKED_IN',
    ];

    // TODO: Once we upgrade to php8.2, we can use something like self::WORKING->value => 'open'
    public const WAREHOUSE_TRANSFER_STATUS_MAPPINGS = [
        'WORKING' => WarehouseTransfer::TRANSFER_STATUS_DRAFT,
        'READY_TO_SHIP' => WarehouseTransfer::TRANSFER_STATUS_DRAFT,
        'SHIPPED' => WarehouseTransfer::TRANSFER_STATUS_OPEN,
        'RECEIVING' => WarehouseTransfer::TRANSFER_STATUS_OPEN,
        'IN_TRANSIT' => WarehouseTransfer::TRANSFER_STATUS_OPEN,
        'DELIVERED' => WarehouseTransfer::TRANSFER_STATUS_OPEN,
        'CHECKED_IN' => WarehouseTransfer::TRANSFER_STATUS_OPEN,
        'CLOSED' => WarehouseTransfer::TRANSFER_STATUS_CLOSED,
    ];

    public const ALLOWED_SHIPMENT_STATUS_MAPPINGS = [
        'WORKING' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_UNSHIPPED,
        'READY_TO_SHIP' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_UNSHIPPED,
        'SHIPPED' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
        'RECEIVING' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
        'IN_TRANSIT' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
        'DELIVERED' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
        'CHECKED_IN' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
        'CLOSED' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
    ];

    public const WAREHOUSE_TRANSFER_RECEIPT_STATUS_MAPPINGS = [
        'WORKING' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'READY_TO_SHIP' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'SHIPPED' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'RECEIVING' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'IN_TRANSIT' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'DELIVERED' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'CHECKED_IN' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'CLOSED' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_RECEIVED,
    ];
}
