<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum AmazonReportTypeEnum: string
{
    use InvokableCases, Values;

    case PRODUCTS = 'GET_MERCHANT_LISTINGS_ALL_DATA';
    case FBA_INVENTORY = 'GET_FBA_MYI_UNSUPPRESSED_INVENTORY_DATA';
    case FBA_REPORT_SHIPMENTS = 'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL';
    case FBA_REPORT_REMOVAL_SHIPMENTS = 'GET_FBA_FULFILLMENT_REMOVAL_SHIPMENT_DETAIL_DATA';
    case FBA_REPORT_REMOVAL_ORDERS = 'GET_FBA_FULFILLMENT_REMOVAL_ORDER_DETAIL_DATA';
    case FBA_REPORT_CUSTOMER_RETURNS = 'GET_FBA_FULFILLMENT_CUSTOMER_RETURNS_DATA';
    case FBA_REPORT_INVENTORY_LEDGER_SUMMARY = 'GET_LEDGER_SUMMARY_VIEW_DATA';
    case FBA_REPORT_INVENTORY_LEDGER = 'GET_LEDGER_DETAIL_VIEW_DATA';
    case FBA_REPORT_RESTOCK = 'GET_RESTOCK_INVENTORY_RECOMMENDATIONS_REPORT';
    case SETTLEMENT_REPORT = 'GET_V2_SETTLEMENT_REPORT_DATA_FLAT_FILE_V2';
    case GET_SELLER_FEEDBACK_DATA = 'GET_SELLER_FEEDBACK_DATA';
    case GET_FBA_ESTIMATED_FBA_FEES_TXT_DATA = 'GET_FBA_ESTIMATED_FBA_FEES_TXT_DATA';

    const REQUESTABLE_REPORTS = [
        'GET_MERCHANT_LISTINGS_ALL_DATA',
        'GET_FBA_MYI_UNSUPPRESSED_INVENTORY_DATA',
        'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL',
        'GET_FBA_FULFILLMENT_REMOVAL_SHIPMENT_DETAIL_DATA',
        'GET_FBA_FULFILLMENT_REMOVAL_ORDER_DETAIL_DATA',
        'GET_FBA_FULFILLMENT_CUSTOMER_RETURNS_DATA',
        'GET_LEDGER_SUMMARY_VIEW_DATA',
        'GET_LEDGER_DETAIL_VIEW_DATA',
        'GET_RESTOCK_INVENTORY_RECOMMENDATIONS_REPORT',
        'GET_SELLER_FEEDBACK_DATA',
        'GET_FBA_ESTIMATED_FBA_FEES_TXT_DATA',
    ];

    /*
     * We specify report delay hours because Amazon has notoriously inaccurate data for the first 72 hours the data
     * exists.  See this blog as reference: https://www.sku.io/amazon-fba-inventory-reconciliation-and-accounting-issue/
     */
    const REPORT_DELAY_HOURS = [
        'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL' => 72,
        'GET_FBA_FULFILLMENT_REMOVAL_SHIPMENT_DETAIL_DATA' => 72,
        'GET_FBA_FULFILLMENT_REMOVAL_ORDER_DETAIL_DATA' => 72,
        'GET_FBA_FULFILLMENT_CUSTOMER_RETURNS_DATA' => 72,
        'GET_LEDGER_DETAIL_VIEW_DATA' => 72,
        'GET_LEDGER_SUMMARY_VIEW_DATA' => 72,
    ];

    const FBA_ADDITIONAL_INVENTORY_REPORTS = [
        self::FBA_REPORT_SHIPMENTS,
        self::FBA_REPORT_REMOVAL_SHIPMENTS,
        self::FBA_REPORT_REMOVAL_ORDERS,
        self::FBA_REPORT_CUSTOMER_RETURNS,
    ];

    const FBA_DETAIL_REPORTS = [
        self::FBA_REPORT_SHIPMENTS,
        self::FBA_REPORT_REMOVAL_SHIPMENTS,
        self::FBA_REPORT_CUSTOMER_RETURNS,
    ];

    const REPLACEABLE_DATA_REPORTS = [
        self::FBA_INVENTORY,
        self::FBA_REPORT_RESTOCK,
    ];

    const FBA_REPORTS = [
        self::FBA_REPORT_SHIPMENTS,
        self::FBA_REPORT_REMOVAL_SHIPMENTS,
        self::FBA_REPORT_REMOVAL_ORDERS,
        self::FBA_REPORT_CUSTOMER_RETURNS,
        self::FBA_INVENTORY,
        self::FBA_REPORT_RESTOCK,
    ];

    const NON_FBA_REPORTS = [
        self::PRODUCTS,
        self::SETTLEMENT_REPORT,
    ];

    const SPLITTABLE_REPORTS = [
        'GET_AMAZON_FULFILLED_SHIPMENTS_DATA_GENERAL' => 30,
    ];

    const MARKETPLACE_REPORTS = [
        'GET_MERCHANT_LISTINGS_ALL_DATA',
    ];
}
