<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum AmazonFeedProcessingStatusEnum: string
{
    use InvokableCases,
        Values;

    // Cases from https://developer-docs.amazon.com/sp-api/docs/feeds-api-v2021-06-30-reference#processingstatus

    case CANCELLED = 'CANCELLED';
    case DONE = 'DONE';
    case FATAL = 'FATAL';
    case IN_PROGRESS = 'IN_PROGRESS';
    case IN_QUEUE = 'IN_QUEUE';

    public const RETRYABLE_STATUSES = [
        self::IN_PROGRESS,
        self::IN_QUEUE,
    ];
}
