<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Amazon\Enums\Entities\AmazonProductFulfillmentChannelEnum;

/**
 * @property int $id
 * @property int $amazon_new_fba_inbound_plan_id
 * @property string $labelOwner
 * @property string $msku
 * @property string $quantity
 * @property string $fnsku
 * @property string $asin
 * @property array $prepInstructions
 * @property array $json_object
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property-read AmazonNewFbaInboundPlan $amazonNewFbaInboundPlan
 * @property-read AmazonProduct $amazonProduct
 */
class AmazonNewFbaInboundPlanItem extends Model
{
    use HasFactory;

    protected $casts = [
        'prepInstructions' => 'array',
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    protected function amazonNewFbaInboundPlan(): BelongsTo
    {
        return $this->belongsTo(AmazonNewFbaInboundPlan::class);
    }

    /**
     * @throws Exception
     */
    public function amazonProduct(): BelongsTo
    {
        return $this->belongsTo(AmazonProduct::class, 'msku', 'seller_sku')
            ->selectRaw('amazon_products.*')
            ->join('amazon_fba_inbound_shipments', 'amazon_products.integration_instance_id', '=', 'amazon_fba_inbound_shipments.integration_instance_id')
            ->whereColumn(
                'amazon_fba_inbound_shipments.integration_instance_id', 'amazon_products.integration_instance_id'
            )
            ->where('amazon_products.fulfillment_channel', '!=', AmazonProductFulfillmentChannelEnum::DEFAULT);
    }
}
