<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $amazon_fulfillment_shipment_id
 * @property-read int $packageNumber
 * @property-read string $carrierCode
 * @property-read string $trackingNumber
 * @property-read string $estimatedArrivalDate
 * @property array $json_object
 * @property-read AmazonFulfillmentShipment $amazonFulfillmentShipment
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentShipmentPackage
 */
class AmazonFulfillmentShipmentPackage extends Model
{
    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFulfillmentShipment(): BelongsTo
    {
        return $this->belongsTo(AmazonFulfillmentShipment::class);
    }
}
