<?php

namespace Modules\Amazon\Entities;

use App\Abstractions\Integrations\IntegrationModelInterface;
use App\Models\SalesOrderFulfillment;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Modules\Amazon\Database\Factories\AmazonFulfillmentOrderFactory;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property ?int $sales_order_fulfillment_id
 * @property string $sellerFulfillmentOrderId
 * @property string $marketplaceId
 * @property string $displayableOrderId
 * @property string $displayableOrderDate
 * @property string $displayableOrderComment
 * @property string $shippingSpeedCategory
 * @property string $deliveryWindow
 * @property array $destinationAddress
 * @property string $fulfillmentAction
 * @property string $fulfillmentPolicy
 * @property array $codSettings
 * @property-read string $receivedDate
 * @property-read string $fulfillmentOrderStatus
 * @property-read string $statusUpdatedDate
 * @property array $notificationEmails
 * @property array $featureConstraints
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read SalesOrderFulfillment $salesOrderFulfillment
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentOrder
 */
class AmazonFulfillmentOrder extends Model implements IntegrationModelInterface
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
        'destinationAddress' => 'array',
        'codSettings' => 'array',
        'notificationEmails' => 'array',
        'featureConstraints' => 'array'
    ];

    public static function getUniqueField(): string
    {
        return 'sellerFulfillmentOrderId';
    }


    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    public function salesOrderFulfillment(): BelongsTo
    {
        return $this->belongsTo(SalesOrderFulfillment::class);
    }

    public function amazonFulfillmentOrderItems(): HasMany
    {
        return $this->hasMany(AmazonFulfillmentOrderItem::class);
    }

    public function amazonFulfillmentReturnAuthorizations(): HasMany
    {
        return $this->hasMany(AmazonFulfillmentReturnAuthorization::class);
    }

    public function amazonFulfillmentShipments(): HasMany
    {
        return $this->hasMany(AmazonFulfillmentShipment::class);
    }

    public static function newFactory()
    {
        return new AmazonFulfillmentOrderFactory();
    }
}
