<?php

namespace Modules\Amazon\Entities;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;
use Modules\Amazon\Enums\Entities\AmazonFinancialEventChargeFeeTypeEnum;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property int $amazon_financial_event_group_id
 * @property-read string $AmazonOrderId
 * @property-read string $SellerOrderId
 * @property-read string $MarketplaceName
 * @property-read string $PostedDate
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read AmazonFinancialEventGroup $amazonFinancialEventGroup
 * @property array $json_object
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 */
class AmazonFinancialShipmentEvent extends AmazonFinancialEvent
{
    protected $casts = [
        'json_object' => 'array',
        'ShipmentItemList' => 'array',
    ];

    protected $fillable = [
        'integration_instance_id',
        'amazon_financial_event_group_id',
        'json_object',
    ];

    public static function getUniqueId(): string
    {
        return 'checksum';
    }

    public static function getTableUniqueId(): string
    {
        return 'checksum';
    }

    public static function getIntegrationName(): string
    {
        return 'amazon';
    }

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    public function amazonFinancialEventGroup(): BelongsTo
    {
        return $this->belongsTo(AmazonFinancialEventGroup::class);
    }

    /**
     * @return Factory<static>
     */
    public static function newFactory(): Factory
    {
        return AmazonFinancialShipmentEvent::new();
    }

    /*
    |--------------------------------------------------------------------------
    | Other Functions
    |--------------------------------------------------------------------------
    */
    public function getAggregatedFinancialLines(AmazonOrderItem $amazonOrderItem): array
    {
        return $this->aggregateFinancialLines($this->json_object['ShipmentItemList'], 'OrderItemId', $amazonOrderItem->OrderItemId, AmazonFinancialEventChargeFeeTypeEnum::ITEM_FEE_LIST->value);
    }
}
