<?php

namespace Modules\Amazon\Entities;

use App\Abstractions\Integrations\SalesChannels\SalesChannelFulfillmentLinkInterface;
use App\Models\SalesOrderFulfillment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Modules\Amazon\Enums\Entities\AmazonFeedTypeEnum;

/**
 * Class AmazonFeed.
 *
 * @property int $id
 * @property string $feedId
 * @property string $feedType
 * @property array $marketplaceIds
 * @property string $inputFeedDocumentId
 * @property array $feedOptions
 * @property string $createdTime
 * @property string $processingStatus
 * @property string $processingStartTime
 * @property string $processingEndTime
 * @property string $resultFeedDocumentId
 * @property string $url
 * @property string $compressionAlgorithm
 * @property array $metadata
 * @property string $filename
 * @property string $resultFeedDocumentXml
 * @property string $requestFeedDocumentXml
 *
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read SalesOrderFulfillment[] $salesOrderFulfillments
 *
 * @mixin IdeHelperAmazonFeedSubmission
 */
class AmazonFeedSubmission extends Model implements SalesChannelFulfillmentLinkInterface
{
    use HasFactory;

    protected $fillable = [
        'integration_instance_id',
        'feedId',
        'feedType',
        'marketplaceIds',
        'inputFeedDocumentId',
        'feedOptions',
        'createdTime',
        'processingStatus',
        'processingStartTime',
        'processingEndTime',
        'resultFeedDocumentId',
        'url',
        'compressionAlgorithm',
        'resultFeedDocumentXml',
        'requestFeedDocumentXml',
    ];

    protected $casts = [
        'feedType' => AmazonFeedTypeEnum::class,
        'marketplaceIds' => 'array',
        'feedOptions' => 'array',
        'metadata' => 'array',
        'requestFeedDocumentXml' => 'string'
    ];

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class, 'integration_instance_id');
    }

    public function salesOrderFulfillments(): MorphMany
    {
        return $this->morphMany(SalesOrderFulfillment::class, 'sales_channel_link');
    }
}
