<?php

namespace Modules\Amazon\Entities;

use App\Abstractions\Integrations\SalesChannels\SalesChannelFulfillmentLinkInterface;
use App\Models\SalesOrderFulfillment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Modules\Amazon\Enums\Entities\AmazonFeedTypeEnum;

/**
 * Class AmazonFeed.
 *
 * @property int $id
 * @property AmazonFeedTypeEnum $feedType
 * @property array $marketplaceIds
 * @property array $feedOptions
 * @property array $metadata
 * @property string $requestFeedDocumentXml
 *
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read SalesOrderFulfillment[] $salesOrderFulfillments
 *
 * @mixin IdeHelperAmazonFeedRequest
 */
class AmazonFeedRequest extends Model implements SalesChannelFulfillmentLinkInterface
{
    use HasFactory;

    protected $casts = [
        'feedType' => AmazonFeedTypeEnum::class,
        'marketplaceIds' => 'array',
        'feedOptions' => 'array',
        'metadata' => 'array',
        'requestFeedDocumentXml' => 'string',
    ];

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class, 'integration_instance_id');
    }

    public function salesOrderFulfillments(): MorphMany
    {
        return $this->morphMany(SalesOrderFulfillment::class, 'sales_channel_link');
    }
}
