<?php

namespace Modules\Amazon\Entities;

use App\DataTable\Exports\DataTableExporter as Exportable;
use App\Exporters\MapsExportableFields;
use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use App\Models\Concerns\HasSort;
use App\Models\Contracts\Filterable;
use App\Models\Contracts\Sortable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property-read string $amazon_order_id
 * @property-read string $merchant_order_id
 * @property-read string $shipment_id
 * @property-read string $shipment_item_id
 * @property-read string $amazon_order_item_id
 * @property-read string $merchant_order_item_id
 * @property-read string $purchase_date
 * @property-read string $payments_date
 * @property-read string $shipment_date
 * @property-read string $reporting_date
 * @property-read Carbon $event_datetime
 * @property-read string $buyer_name
 * @property-read string $buyer_phone_number
 * @property-read string $sku
 * @property-read string $product_name
 * @property-read int $quantity_shipped
 * @property-read string $currency
 * @property-read float $item_price
 * @property-read float $item_tax
 * @property-read float $shipping_price
 * @property-read float $shipping_tax
 * @property-read float $gift_wrap_price
 * @property-read float $gift_wrap_tax
 * @property-read string $ship_service_level
 * @property-read string $recipient_name
 * @property-read string $ship_address1
 * @property-read string $ship_address2
 * @property-read string $ship_address3
 * @property-read string $ship_city
 * @property-read string $ship_state
 * @property-read string $ship_postal_code
 * @property-read string $ship_country
 * @property-read string $ship_phone_number
 * @property-read string $bill_address1
 * @property-read string $bill_address2
 * @property-read string $bill_address3
 * @property-read string $bill_city
 * @property-read string $bill_state
 * @property-read string $bill_postal_code
 * @property-read string $bill_country
 * @property-read float $item_promotion_discount
 * @property-read float $ship_promotion_discount
 * @property-read string $carrier
 * @property-read string $tracking_number
 * @property-read string $estimated_arrival_date
 * @property-read string $fulfillment_center_id
 * @property-read string $fulfillment_channel
 * @property-read string $sales_channel
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read AmazonReport $amazonReport
 * @property-read AmazonFbaReportInventoryLedger $ledger
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFbaReportShipment
 */
class AmazonFbaReportShipment extends AbstractAmazonFbaDetailReport implements Filterable, MapsExportableFields, Sortable
{
    use BulkImport;
    use HasFilters;
    use HasSort;

    protected $casts = [
        'event_datetime' => 'datetime',
        'json_object' => 'array',
    ];

    public function getDateField(): string
    {
        return 'reporting_date';
    }

    public static function getQuantityField(): string
    {
        return 'quantity_shipped';
    }

    public static function hasNegativeLedgerImpact(): bool
    {
        return true;
    }


    public static function getExportableFields(): array
    {
        return [
            'id' => Exportable::makeExportableField('id', false),
            'amazon_order_id' => Exportable::makeExportableField('amazon_order_id', false),
            'merchant_order_id' => Exportable::makeExportableField('merchant_order_id', false),
            'shipment_id' => Exportable::makeExportableField('shipment_id', false),
            'shipment_item_id' => Exportable::makeExportableField('shipment_item_id', false),
            'amazon_order_item_id' => Exportable::makeExportableField('amazon_order_item_id', false),
            'merchant_order_item_id' => Exportable::makeExportableField('merchant_order_item_id', false),
            'purchase_date' => Exportable::makeExportableField('purchase_date', false),
            'payments_date' => Exportable::makeExportableField('payments_date', false),
            'shipment_date' => Exportable::makeExportableField('shipment_date', false),
            'reporting_date' => Exportable::makeExportableField('reporting_date', false),
            'event_datetime' => Exportable::makeExportableField('event_datetime', false),
            'buyer_name' => Exportable::makeExportableField('buyer_name', false),
            'buyer_phone_number' => Exportable::makeExportableField('buyer_phone_number', false),
            'sku' => Exportable::makeExportableField('sku', false),
            'product_name' => Exportable::makeExportableField('product_name', false),
            'quantity_shipped' => Exportable::makeExportableField('quantity_shipped', false),
            'currency' => Exportable::makeExportableField('currency', false),
            'item_price' => Exportable::makeExportableField('item_price', false),
            'item_tax' => Exportable::makeExportableField('item_tax', false),
            'shipping_price' => Exportable::makeExportableField('shipping_price', false),
            'shipping_tax' => Exportable::makeExportableField('shipping_tax', false),
            'gift_wrap_price' => Exportable::makeExportableField('gift_wrap_price', false),
            'gift_wrap_tax' => Exportable::makeExportableField('gift_wrap_tax', false),
            'ship_service_level' => Exportable::makeExportableField('ship_service_level', false),
            'recipient_name' => Exportable::makeExportableField('recipient_name', false),
            'ship_address1' => Exportable::makeExportableField('ship_address1', false),
            'ship_address2' => Exportable::makeExportableField('ship_address2', false),
            'ship_address3' => Exportable::makeExportableField('ship_address3', false),
            'ship_city' => Exportable::makeExportableField('ship_city', false),
            'ship_state' => Exportable::makeExportableField('ship_state', false),
            'ship_postal_code' => Exportable::makeExportableField('ship_postal_code', false),
            'ship_country' => Exportable::makeExportableField('ship_country', false),
            'ship_phone_number' => Exportable::makeExportableField('ship_phone_number', false),
            'bill_address1' => Exportable::makeExportableField('bill_address1', false),
            'bill_address2' => Exportable::makeExportableField('bill_address2', false),
            'bill_address3' => Exportable::makeExportableField('bill_address3', false),
            'bill_city' => Exportable::makeExportableField('bill_city', false),
            'bill_state' => Exportable::makeExportableField('bill_state', false),
            'bill_postal_code' => Exportable::makeExportableField('bill_postal_code', false),
            'bill_country' => Exportable::makeExportableField('bill_country', false),
            'item_promotion_discount' => Exportable::makeExportableField('item_promotion_discount', false),
            'ship_promotion_discount' => Exportable::makeExportableField('ship_promotion_discount', false),
            'carrier' => Exportable::makeExportableField('carrier', false),
            'tracking_number' => Exportable::makeExportableField('tracking_number', false),
            'estimated_arrival_date' => Exportable::makeExportableField('estimated_arrival_date', false),
            'fulfillment_center_id' => Exportable::makeExportableField('fulfillment_center_id', false),
            'fulfillment_channel' => Exportable::makeExportableField('fulfillment_channel', false),
            'sales_channel' => Exportable::makeExportableField('sales_channel', false),
            'created_at' => Exportable::makeExportableField('created_at', false),
            'updated_at' => Exportable::makeExportableField('updated_at', false),

        ];
    }

    public function reportType(): AmazonReportTypeEnum
    {
        return AmazonReportTypeEnum::FBA_REPORT_SHIPMENTS;
    }

    public function amazonReport(): BelongsTo
    {
        return $this->belongsTo(AmazonReport::class);
    }

    public function filterableColumns(): array
    {
        return collect($this->availableColumns())->where('filterable', 1)->pluck('data_name')->all();
    }

    public function availableColumns()
    {
        return config('data_table.amazon.fba_report_shipment.columns');

    }

    public function generalFilterableColumns(): array
    {
        return [];
    }

    public function sortableColumns()
    {
        return collect($this->availableColumns())->where('sortable', 1)->pluck('data_name')->all();
    }
}
