<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_shipment_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_shipment_event_id')->constrained()->index('afs_parent_index');
            $table->string('SellerSKU')->storedAs('json_extract(json_object, "$.SellerSKU")');
            $table->string('OrderItemId')->nullable()->storedAs('json_extract(json_object, "$.OrderItemId")');
            $table->string('OrderAdjustmentItemId')->nullable()->storedAs('json_extract(json_object, "$.OrderAdjustmentItemId")');
            $table->integer('QuantityShipped')->storedAs('json_extract(json_object, "$.QuantityShipped")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_shipment_items');
    }
};
