<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_removal_shipment_adjustment_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_removal_shipment_adjustment_event_id')->constrained()->index('afrsa_parent_index');
            $table->string('RemovalShipmentItemId')->storedAs('json_extract(json_object, "$.RemovalShipmentItemId")');
            $table->string('TaxCollectionModel')->storedAs('json_extract(json_object, "$.TaxCollectionModel")');
            $table->string('FulfillmentNetworkSKU')->storedAs('json_extract(json_object, "$.FulfillmentNetworkSKU")');
            $table->integer('AdjustedQuantity')->storedAs('json_extract(json_object, "$.AdjustedQuantity")');
            $table->decimal('RevenueAdjustmentCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.RevenueAdjustment.CurrencyAmount")');
            $table->string('RevenueAdjustmentCurrencyCode')->storedAs('json_extract(json_object, "$.RevenueAdjustment.CurrencyCode")');
            $table->decimal('TaxAdjustmentCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxAmountAdjustment.CurrencyAmount")');
            $table->string('TaxAdjustmentCurrencyCode')->storedAs('json_extract(json_object, "$.TaxAmountAdjustment.CurrencyCode")');
            $table->decimal('TaxWithheldAdjustmentCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxWithheldAdjustment.CurrencyAmount")');
            $table->string('TaxWithheldAdjustmentCurrencyCode')->storedAs('json_extract(json_object, "$.TaxWithheldAdjustment.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_removal_shipment_adjustment_items');
    }
};
