<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_adjustment_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_financial_adjustment_event_id')->constrained()->index('afa_parent_index');
            $table->string('Quantity')->storedAs('json_extract(json_object, "$.Quantity")');
            $table->decimal('PerUnitCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.PerUnitAmount.CurrencyAmount")');
            $table->string('PerUnitCurrencyCode')->storedAs('json_extract(json_object, "$.PerUnitAmount.CurrencyCode")');
            $table->decimal('TotalCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TotalAmount.CurrencyAmount")');
            $table->string('TotalCurrencyCode')->storedAs('json_extract(json_object, "$.TotalAmount.CurrencyCode")');
            $table->string('SellerSKU')->nullable()->storedAs('json_extract(json_object, "$.SellerSKU")');
            $table->string('FnSKU')->nullable()->storedAs('json_extract(json_object, "$.FnSKU")');
            $table->string('ProductDescription')->storedAs('json_extract(json_object, "$.ProductDescription")');
            $table->string('ASIN')->storedAs('json_extract(json_object, "$.ASIN")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_adjustment_items');
    }
};
