<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_tax_withholding_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('aftwe_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('aftwe_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->decimal('BaseCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.BaseAmount.CurrencyAmount")');
            $table->string('BaseCurrencyCode')->storedAs('json_extract(json_object, "$.BaseAmount.CurrencyCode")');
            $table->decimal('WithheldCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.WithheldAmount.CurrencyAmount")');
            $table->string('WithheldCurrencyCode')->storedAs('json_extract(json_object, "$.WithheldAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_tax_withholding_events');
    }
};
