<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_service_fee_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afsfe_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afsfe_amazon_financial_event_group_index');
            $table->string('AmazonOrderId')->storedAs('json_extract(json_object, "$.AmazonOrderId")');
            $table->string('FeeReason')->storedAs('json_extract(json_object, "$.FeeReason")');
            $table->string('SellerSKU')->storedAs('json_extract(json_object, "$.SellerSKU")');
            $table->string('FnSKU')->storedAs('json_extract(json_object, "$.FnSKU")');
            $table->string('FeeDescription')->storedAs('json_extract(json_object, "$.FeeDescription")');
            $table->string('ASIN')->storedAs('json_extract(json_object, "$.ASIN")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_service_fee_events');
    }
};
