<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_seller_review_enrollment_payment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afsrepe_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afsrepe_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('EnrollmentId')->storedAs('json_extract(json_object, "$.EnrollmentId")');
            $table->string('ParentASIN')->storedAs('json_extract(json_object, "$.ParentASIN")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TotalAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.TotalAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_seller_review_enrollment_payment_events');
    }
};
