<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_seller_deal_payment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afsdpe_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afsdpe_amazon_financial_event_group_index');
            $table->string('postedDate')->storedAs('json_extract(json_object, "$.postedDate")');
            $table->string('dealId')->storedAs('json_extract(json_object, "$.dealId")');
            $table->string('dealDescription')->storedAs('json_extract(json_object, "$.dealDescription")');
            $table->string('eventType')->storedAs('json_extract(json_object, "$.eventType")');
            $table->string('feeType')->storedAs('json_extract(json_object, "$.feeType")');
            $table->decimal('feeCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.feeAmount.CurrencyAmount")');
            $table->string('feeCurrencyCode')->storedAs('json_extract(json_object, "$.feeAmount.CurrencyCode")');
            $table->decimal('taxCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.taxAmount.CurrencyAmount")');
            $table->string('taxCurrencyCode')->storedAs('json_extract(json_object, "$.taxAmount.CurrencyCode")');
            $table->decimal('totalAmount', 10, 2)->storedAs('json_extract(json_object, "$.totalAmount.CurrencyAmount")');
            $table->string('totalCurrencyCode')->storedAs('json_extract(json_object, "$.totalAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_seller_deal_payment_events');
    }
};
