<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_safet_reimbursement_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afsre_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afsre_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('SAFETClaimId')->storedAs('json_extract(json_object, "$.SAFETClaimId")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.ReimbursedAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.ReimbursedAmount.CurrencyCode")');
            $table->string('ReasonCode')->storedAs('json_extract(json_object, "$.ReasonCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_safet_reimbursement_events');
    }
};
