<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_removal_shipment_adjustment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afrsae_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afrsae_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('AdjustmentEventId')->storedAs('json_extract(json_object, "$.AdjustmentEventId")');
            $table->string('MerchantOrderId')->storedAs('json_extract(json_object, "$.MerchantOrderId")');
            $table->string('OrderId')->storedAs('json_extract(json_object, "$.OrderId")');
            $table->string('TransactionType')->storedAs('json_extract(json_object, "$.TransactionType")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_removal_shipment_adjustment_events');
    }
};
