<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_network_commingling_transaction_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afnct_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afnct_amazon_financial_event_group_index');
            $table->string('TransactionType')->storedAs('json_extract(json_object, "$.TransactionType")');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('NetCoTransactionID')->storedAs('json_extract(json_object, "$.NetCoTransactionID")');
            $table->string('SwapReason')->storedAs('json_extract(json_object, "$.SwapReason")');
            $table->string('ASIN')->storedAs('json_extract(json_object, "$.ASIN")');
            $table->string('MarketplaceId')->storedAs('json_extract(json_object, "$.MarketplaceId")');
            $table->decimal('TaxExclusiveCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxExclusiveAmount.CurrencyAmount")');
            $table->string('TaxExclusiveCurrencyCode')->storedAs('json_extract(json_object, "$.TaxExclusiveAmount.CurrencyCode")');
            $table->decimal('TaxCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.TaxAmount.CurrencyAmount")');
            $table->string('TaxCurrencyCode')->storedAs('json_extract(json_object, "$.TaxAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_network_commingling_transaction_events');
    }
};
