<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_loan_servicing_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('aflse_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('aflse_amazon_financial_event_group_index');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.LoanAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.LoanAmount.CurrencyCode")');
            $table->string('SourceBusinessEventType')->storedAs('json_extract(json_object, "$.SourceBusinessEventType")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_loan_servicing_events');
    }
};
