<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_fba_liquidation_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('affle_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('affle_amazon_financial_event_group_index');
            $table->string('PostedDate')->storedAs('json_extract(json_object, "$.PostedDate")');
            $table->string('OriginalRemovalOrderId')->storedAs('json_extract(json_object, "$.OriginalRemovalOrderId")');
            $table->decimal('LiquidationProceedsCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.LiquidationProceedsAmount.CurrencyAmount")');
            $table->string('LiquidationProceedsCurrencyCode')->storedAs('json_extract(json_object, "$.LiquidationProceedsAmount.CurrencyCode")');
            $table->decimal('LiquidationFeeCreditCurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.LiquidationFeeAmount.CurrencyAmount")');
            $table->string('LiquidationFeeCreditCurrencyCode')->storedAs('json_extract(json_object, "$.LiquidationFeeAmount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_fba_liquidation_events');
    }
};
