<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_new_fba_inbound_plans', function (Blueprint $table) {
            $table->foreign('integration_instance_id', 'amazon_new_fba_inbound_plans_integration_instance_id_foreign')->references('id')->on('integration_instances')->onDelete('restrict');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_new_fba_inbound_plans', function (Blueprint $table) {
            $table->dropForeign('amazon_new_fba_inbound_plans_integration_instance_id_foreign');
        });
    }
};
