<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fulfillment_orders', function (Blueprint $table) {
            $table->foreign('sales_order_fulfillment_id')->references('id')->on('sales_order_fulfillments')->restrictOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fulfillment_orders', function (Blueprint $table) {
            $table->dropForeign(['sales_order_fulfillment_id']);
        });
    }
};
