<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_new_fba_inbound_shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_new_fba_inbound_plan_id')->index('amazonFbaInboundPlanIndex');
            $table->foreignId('integration_instance_id')->index('integrationInstanceIndex');
            $table->integer('sku_link_id')->nullable();
            $table->string('sku_link_type')->nullable();
            $table->boolean('is_before_initial_count')->default(false);
            $table->string('name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.name'))");
            $table->string('sourceName')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.source.address.name'))");
            $table->string('shipmentId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipmentId'))");
            $table->string('status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.status'))");
            $table->string('amazonReferenceId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazonReferenceId'))");
            $table->string('shipmentConfirmationId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipmentConfirmationId'))");
            $table->string('destinationCountry')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.destination.address.countryCode'))");
            $table->string('destinationWarehouse')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.destination.warehouseId'))");
            $table->string('destinationType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.destination.destinationType'))");
            $table->json('destination')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.destination'))");
            $table->json('source')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.source'))");
            $table->string('selectedTransportationOptionId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.selectedTransportationOptionId'))");
            $table->string('placementOptionId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.placementOptionId'))");
            $table->string('errorLog')->nullable();
            $table->json('json_object');
            $table->timestamps();
            $table->index(['sku_link_id', 'sku_link_type'], 'skuLinkIndex');
            $table->unique(['integration_instance_id', 'shipmentId'], 'amazon_fba_inbound_shipments_unique_shipment_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_new_fba_inbound_shipments');
    }
};
