<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_new_fba_inbound_plan_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_new_fba_inbound_plan_id');
            $table->string('labelOwner')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.labelOwner'))");
            $table->string('msku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.msku'))");
            $table->string('quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('asin')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.asin'))");
            $table->json('prepInstructions')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.prepInstructions'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_new_fba_inbound_plan_items');
    }
};
