<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_new_fba_inbound_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index('integrationInstanceIndex');
            $table->string('inboundPlanId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.inboundPlanId'))");
            $table->string('name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.name'))");
            $table->string('sourceName')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sourceAddress.name'))");
            $table->string('status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.status'))");
            $table->string('lastUpdatedAt')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.lastUpdatedAt'))");
            $table->string('createdAt')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.createdAt'))");
            $table->json('shipments')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipments'))")->nullable();
            $table->json('sourceAddress')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sourceAddress'))")->nullable();
            $table->json('json_object');
            $table->timestamps();
            $table->unique(['integration_instance_id', 'inboundPlanId'], 'integrationInstanceInboundPlanIdIndex');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_new_fba_inbound_shipment_plans');
    }
};
