<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_orders', function (Blueprint $table) {
            $table->index(['SalesChannel', 'integration_instance_id'], 'idx_amazon_orders_sales_channel');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_orders', function (Blueprint $table) {
            $table->dropIndex('idx_amazon_orders_sales_channel');
        });
    }
};
