<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fulfillment_shipments', function (Blueprint $table) {
            $table->unique('amazonShipmentId', 'amazon_fulfillment_shipments_unique_idx');
        });

        Schema::table('amazon_fulfillment_shipment_items', function (Blueprint $table) {
            $table->unique(['amazon_fulfillment_shipment_id', 'sellerFulfillmentOrderItemId'], 'amazon_fulfillment_shipment_items_unique_idx');
        });

        Schema::table('amazon_fulfillment_shipment_packages', function (Blueprint $table) {
            $table->unique(['amazon_fulfillment_shipment_id', 'packageNumber'], 'amazon_fulfillment_shipment_packages_unique_idx');
        });
    }
};
