<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_ledger_summary_adjustments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('amazon_fba_report_inventory_ledger_summary_id');
            $table->string('type');
            $table->unsignedBigInteger('sku_link_id');
            $table->string('sku_link_type');
            $table->timestamps();
            $table->foreign('amazon_fba_report_inventory_ledger_summary_id', 'ledger_summary_adjustment_summary_id_foreign')
                ->references('id')
                ->on('amazon_fba_report_inventory_ledger_summaries')
                ->onDelete('restrict');
            $table->unique(['amazon_fba_report_inventory_ledger_summary_id', 'sku_link_id', 'sku_link_type'], 'unique_adjustment');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_ledger_summary_adjustments');
    }
};
