<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_transfer_receipt_group_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('amazon_transfer_receipt_group_id');
            $table->unsignedBigInteger('sku_link_id');
            $table->string('sku_link_type');
            $table->foreign('amazon_transfer_receipt_group_id', 'atrgl_atrg_fk')
                ->references('id')
                ->on('amazon_transfer_receipt_groups')
                ->onDelete('restrict');
            $table->unique(['amazon_transfer_receipt_group_id', 'sku_link_id', 'sku_link_type'], 'receipt_group_lines_unique_idx');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_transfer_receipt_group_lines');
    }
};
