<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_report_removal_orders', function (Blueprint $table) {
            $table->unique(['integration_instance_id', 'order_id', 'fnsku', 'disposition'], 'amazon_fba_report_removal_orders_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_report_removal_orders', function (Blueprint $table) {
            $table->dropUnique('amazon_fba_report_removal_orders_unique_idx');
        });
    }
};
