<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->dropIndex('amazon_fba_report_inventory_ledger_detail_id_detail_type_index');
            $table->dropColumn('detail_id');
            $table->dropColumn('detail_type');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->unsignedBigInteger('detail_id');
            $table->string('detail_type');
            $table->index(['detail_id', 'detail_type'], 'amazon_fba_report_inventory_ledger_detail_id_detail_type_index');
        });
    }
};
