<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_ledger_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('amazon_fba_report_inventory_ledger_id');
            $table->unsignedBigInteger('detail_id');
            $table->string('detail_type');
            $table->timestamps();
            $table->foreign('amazon_fba_report_inventory_ledger_id', 'afri_ledger_fk')
                ->references('id')
                ->on('amazon_fba_report_inventory_ledger')
                ->onDelete('restrict');
            $table->unique(['amazon_fba_report_inventory_ledger_id', 'detail_id', 'detail_type'], 'amazon_ledger_details_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_ledger_details');
    }
};
