<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_initial_inventory', function (Blueprint $table) {
            $table->integer('total_inventory_quantity')->storedAs('in_transit_between_warehouses + ending_warehouse_balance')->after('ending_warehouse_balance');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_initial_inventory', function (Blueprint $table) {
            $table->dropColumn('total_inventory_quantity');
        });
    }
};
