<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            // Check and drop foreign key
            $foreignKeyName = 'amazon_fnsku_products_integration_instance_id_foreign';
            $table->dropForeign($foreignKeyName);

            // Check and drop unique index
            $uniqueIndexName = 'amazon_fnsku_products_integration_instance_id_fnsku_unique';
            $table->dropUnique($uniqueIndexName);

        });

        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->foreign('integration_instance_id', 'amazon_fnsku_products_integration_instance_id_foreign')->references('id')->on('integration_instances')->onDelete('restrict');
            $table->unique(['integration_instance_id', 'fnsku', 'location', 'disposition'], 'fnsku_products_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->foreign('integration_instance_id', 'amazon_fnsku_products_integration_instance_id_foreign')->references('id')->on('integration_instances')->onDelete('restrict');
            $table->unique(['integration_instance_id', 'fnsku'], 'amazon_fnsku_products_integration_instance_id_fnsku_unique');
        });
    }
};