<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger_summaries', function (Blueprint $table) {
            $table->dropUnique('amazon_fba_report_inventory_ledger_summaries_fnsku_index');
            $table->unique(['integration_instance_id', 'fnsku', 'location', 'disposition'], 'ledger_summaries_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger_summaries', function (Blueprint $table) {
            $table->dropUnique('ledger_summaries_unique_idx');
            $table->unique(['integration_instance_id', 'fnsku'], 'amazon_fba_report_inventory_ledger_summaries_fnsku_index');
        });
    }
};
