<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->string('location')->after('fnsku');
            $table->string('disposition')->after('location');
            $table->json('potential_product_matches')->nullable()->after('product_id');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fnsku_products', function (Blueprint $table) {
            $table->dropColumn('location');
            $table->dropColumn('disposition');
            $table->dropColumn('potential_product_matches');
        });
    }
};
