<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_inbound_shipments', function (Blueprint $table) {
            $table->unique(['integration_instance_id', 'ShipmentId'], 'amazon_fba_inbound_shipments_unique_shipment_id');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_fba_inbound_shipments', function (Blueprint $table) {
            $table->dropUnique('amazon_fba_inbound_shipments_unique_shipment_id');
        });
    }
};
