<?php

use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement('ALTER TABLE amazon_fba_report_removal_orders
        DROP COLUMN IF EXISTS requested_quantity,
        DROP COLUMN IF EXISTS cancelled_quantity,
        DROP COLUMN IF EXISTS disposed_quantity,
        DROP COLUMN IF EXISTS shipped_quantity,
        DROP COLUMN IF EXISTS in_process_quantity,
        DROP COLUMN IF EXISTS removal_fee');

        DB::statement("ALTER TABLE amazon_fba_report_removal_orders
        ADD COLUMN removal_fee DECIMAL(12, 4) AS (CASE WHEN json_unquote(json_extract(`json_object`,'$.removal_fee')) = '' THEN 0 ELSE cast(json_unquote(json_extract(`json_object`,'$.removal_fee')) as DECIMAL(12, 4)) END) STORED AFTER disposition,
        ADD COLUMN in_process_quantity INT UNSIGNED AS (CASE WHEN json_unquote(json_extract(`json_object`,'$.in_process_quantity')) = '' THEN 0 ELSE cast(json_unquote(json_extract(`json_object`,'$.in_process_quantity')) as unsigned) END) STORED AFTER disposition,
        ADD COLUMN shipped_quantity INT UNSIGNED AS (CASE WHEN json_unquote(json_extract(`json_object`,'$.shipped_quantity')) = '' THEN 0 ELSE cast(json_unquote(json_extract(`json_object`,'$.shipped_quantity')) as unsigned) END) STORED AFTER disposition,
        ADD COLUMN disposed_quantity INT UNSIGNED AS (CASE WHEN json_unquote(json_extract(`json_object`,'$.disposed_quantity')) = '' THEN 0 ELSE cast(json_unquote(json_extract(`json_object`,'$.disposed_quantity')) as unsigned) END) STORED AFTER disposition,
        ADD COLUMN cancelled_quantity INT UNSIGNED AS (CASE WHEN json_unquote(json_extract(`json_object`,'$.cancelled_quantity')) = '' THEN 0 ELSE cast(json_unquote(json_extract(`json_object`,'$.cancelled_quantity')) as unsigned) END) STORED AFTER disposition,
        ADD COLUMN requested_quantity INT UNSIGNED AS (CASE WHEN json_unquote(json_extract(`json_object`,'$.requested_quantity')) = '' THEN 0 ELSE cast(json_unquote(json_extract(`json_object`,'$.requested_quantity')) as unsigned) END) STORED AFTER disposition");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('ALTER TABLE amazon_fba_report_removal_orders
        DROP COLUMN IF EXISTS requested_quantity,
        DROP COLUMN IF EXISTS cancelled_quantity,
        DROP COLUMN IF EXISTS disposed_quantity,
        DROP COLUMN IF EXISTS shipped_quantity,
        DROP COLUMN IF EXISTS in_process_quantity,
        DROP COLUMN IF EXISTS removal_fee');

        DB::statement("ALTER TABLE amazon_fba_report_removal_orders
        ADD COLUMN removal_fee DECIMAL(12, 4) AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.removal_fee')) AS DECIMAL(12,4))) STORED AFTER disposition,
        ADD COLUMN in_process_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.in_process_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN shipped_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipped_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN disposed_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposed_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN cancelled_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.cancelled_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN requested_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.requested_quantity')) AS UNSIGNED)) STORED AFTER disposition");
    }
};
