<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement('ALTER TABLE amazon_fba_report_removal_orders
        DROP COLUMN requested_quantity,
        DROP COLUMN cancelled_quantity,
        DROP COLUMN disposed_quantity,
        DROP COLUMN shipped_quantity,
        DROP COLUMN in_process_quantity,
        DROP COLUMN removal_fee');

        DB::statement("ALTER TABLE amazon_fba_report_removal_orders
        ADD COLUMN removal_fee DECIMAL(12, 4) AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.removal_fee')) AS DECIMAL(12,4))) STORED AFTER disposition,
        ADD COLUMN in_process_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.in_process_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN shipped_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipped_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN disposed_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposed_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN cancelled_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.cancelled_quantity')) AS UNSIGNED)) STORED AFTER disposition,
        ADD COLUMN requested_quantity INT UNSIGNED AS (CAST(JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.requested_quantity')) AS UNSIGNED)) STORED AFTER disposition");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('ALTER TABLE amazon_fba_report_removal_orders
        DROP COLUMN requested_quantity,
        DROP COLUMN cancelled_quantity,
        DROP COLUMN disposed_quantity,
        DROP COLUMN shipped_quantity,
        DROP COLUMN in_process_quantity,
        DROP COLUMN removal_fee');

        DB::statement("ALTER TABLE amazon_fba_report_removal_orders
        ADD COLUMN removal_fee DECIMAL(12, 4) AS (JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.removal_fee'))) STORED AFTER disposition,
        ADD COLUMN in_process_quantity INT UNSIGNED AS (JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.in_process_quantity'))) STORED AFTER disposition,
        ADD COLUMN shipped_quantity INT UNSIGNED AS (JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipped_quantity'))) STORED AFTER disposition,
        ADD COLUMN disposed_quantity INT UNSIGNED AS (JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposed_quantity'))) STORED AFTER disposition,
        ADD COLUMN cancelled_quantity INT UNSIGNED AS (JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.cancelled_quantity'))) STORED AFTER disposition,
        ADD COLUMN requested_quantity INT UNSIGNED AS (JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.requested_quantity'))) STORED AFTER disposition");
    }
};
